<?php

namespace Database\Seeders\Admin;

use Illuminate\Database\Seeder;
use App\Models\Admin\PaymentGateway;
use App\Models\Admin\PaymentGatewayCurrency;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        //gateway
        $payment_gateways = array(
            array('id' => '1','slug' => 'add-money','code' => '105','type' => 'AUTOMATIC','name' => 'Paypal','title' => 'Paypal Gateway','alias' => 'paypal','image' => '056c00f2-b983-499f-b53e-c27d66410866.webp','credentials' => '[{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"EOmsQW73ja4jFXUIpkeTuKj5qLcqiXRCPZMPx-2UNzNy729C5lzN8cYIdZRfHIx7xPVh9cyaeByefXJL"},{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"AZhkSGtOqSoGsixors18c5UDkmHD53TzNogt2ksVfxqDeu1RzqdjMClVv8VGarayaAH1exMK0JHMjE8v"}]','supported_currencies' => '["USD","AUD","CAD","GBP","SGD","BRL","EUR","RUB"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
            array('id' => '2','slug' => 'add-money','code' => '106','type' => 'AUTOMATIC','name' => 'Stripe','title' => 'Stripe Gateway','alias' => 'stripe','image' => '25cc3ebb-13cb-4aa9-83df-77ebf1e8a785.webp','credentials' => '[{"label":"Publishable Key","placeholder":"Enter Publishable Key","name":"publishable-key","value":"pk_test_51NECrlJXLo7QTdMco2E4YxHSeoBnDvKmmi0CZl3hxjGgH1JwgcLVUF3ZR0yFraoRgT7hf0LtOReFADhShAZqTNuB003PnBSlGP"},{"label":"Secret Id","placeholder":"Enter Secret ID","name":"secret-id","value":"sk_test_51NECrlJXLo7QTdMc2x7K5LaDuiS0MGNYHkO9dzzV0Y9XuWNZsXjECFsusjZEnqtxMIjCh3qtogc5sHHwL2oQ083900aFy1k7DE"}]','supported_currencies' => '["USD","AUD","AED","BDT","BGN","CAD","EGP","EUR","GBP","INR"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
            array('id' => '3','slug' => 'add-money','code' => '110','type' => 'MANUAL','name' => 'AdPay (Manual)','title' => 'AdPay (Manual) Gateway','alias' => 'adpay-manual','image' => '6fe0ddbe-9c0c-4326-95bd-29ac7711b649.webp','credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:36:51'),
            array('id' => '4','slug' => 'add-money','code' => '115','type' => 'MANUAL','name' => 'Bkash(Manual)','title' => 'Bkash(Manual) Gateway','alias' => 'bkashmanual','image' => '7bee42e7-b1e9-4fe4-8db8-973b859babc7.webp','credentials' => NULL,'supported_currencies' => '["BDT"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:14'),
            array('id' => '5','slug' => 'add-money','code' => '120','type' => 'MANUAL','name' => 'Khalti(Manual)','title' => 'Khalti(Manual) Gateway','alias' => 'khaltimanual','image' => '774e5db2-b461-4285-ad64-1caf6e5a0716.webp','credentials' => NULL,'supported_currencies' => '["NPR"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:33'),
            array('id' => '6','slug' => 'add-money','code' => '125','type' => 'MANUAL','name' => 'JazzCash(Manual)','title' => 'JazzCash(Manual) Gateway','alias' => 'jazzcashmanual','image' => 'c42ea4db-5067-4dda-92a1-4e00f20b5aaf.webp','credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:53'),
            array('id' => '7','slug' => 'add-money','code' => '130','type' => 'MANUAL','name' => 'EasyPaisa(Manual)','title' => 'EasyPaisa(Manual) Gateway','alias' => 'easypaisamanual','image' => '957603b7-d30a-4b70-b4d1-81d8c67ba751.webp','credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:05'),
            array('id' => '8','slug' => 'add-money','code' => '135','type' => 'MANUAL','name' => 'PhonePe(Manual)','title' => 'PhonePe(Manual) Gateway','alias' => 'phonepemanual','image' => 'd6dcbd50-d68e-4535-ae2f-c35e3eb56872.webp','credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:17'),
            array('id' => '9','slug' => 'add-money','code' => '140','type' => 'MANUAL','name' => 'UPI(Manual)','title' => 'UPI(Manual) Gateway','alias' => 'upimanual','image' => '80c9caa2-abc3-48c6-b239-778f10888632.webp','credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>This is the manual payment gateway for StripCard, Please follow the payment instruction and sumit required information.</p><p>.</p>','input_fields' => '[{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"text","label":"Phone Number","name":"phone_number","required":true,"validation":{"max":"30","mimes":[],"min":"0","options":[],"required":true}},{"type":"file","label":"Screenshoot","name":"screenshoot","required":true,"validation":{"max":"10","mimes":["jpg","png","webp"],"min":0,"options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:30'),
            array('id' => '10','slug' => 'money-out','code' => '145','type' => 'MANUAL','name' => 'StripCard(Manual)','title' => 'StripCard(Manual) Gateway','alias' => 'stripcardmanual','image' => '274b95fc-258a-445e-ad96-6d91783e6d9b.webp','credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>This is the manual withdraw gateway for StripCard, Please follow the withdraw instruction and sumit required information.</p>','input_fields' => '[{"type":"text","label":"Email","name":"email","required":true,"validation":{"max":"30","mimes":[],"min":"5","options":[],"required":true}},{"type":"text","label":"Card Number","name":"card_number","required":true,"validation":{"max":"30","mimes":[],"min":"16","options":[],"required":true}},{"type":"text","label":"Card Expiry","name":"card_expiry","required":true,"validation":{"max":"30","mimes":[],"min":"4","options":[],"required":true}},{"type":"text","label":"CVC","name":"cvc","required":true,"validation":{"max":"30","mimes":[],"min":"3","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-10-03 13:34:59'),
            array('id' => '11','slug' => 'add-money','code' => '210','type' => 'AUTOMATIC','name' => 'SSLCommerz','title' => 'SSLCommerz Payment Gateway For Add Money','alias' => 'sslcommerz','image' => 'f4fe90e9-9b25-48b8-b3f5-9847cfbc6da7.webp','credentials' => '[{"label":"Store Id","placeholder":"Enter Store Id","name":"store-id","value":"appde6513b3970d62c"},{"label":"Store Password","placeholder":"Enter Store Password","name":"store-password","value":"appde6513b3970d62c@ssl"},{"label":"Sandbox Url","placeholder":"Enter Sandbox Url","name":"sandbox-url","value":"https:\\/\\/sandbox.sslcommerz.com"},{"label":"Live Url","placeholder":"Enter Live Url","name":"live-url","value":"https:\\/\\/securepay.sslcommerz.com"}]','supported_currencies' => '["BDT","EUR","GBP","AUD","USD","CAD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-09-27 16:11:26','updated_at' => '2023-09-27 16:11:53','env' => 'SANDBOX'),
            array('id' => '12','slug' => 'add-money','code' => '200','type' => 'AUTOMATIC','name' => 'RazorPay','title' => 'Razor Pay Payment Gateway','alias' => 'razorpay','image' => '7f46e145-774e-41bf-9170-243605a5d4d0.webp','credentials' => '[{"label":"Key ID","placeholder":"Enter Key ID","name":"key-id","value":"rzp_test_voV4gKUbSxoQez"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"cJltc1jy6evA4Vvh9lTO7SWr"}]','supported_currencies' => '["USD","EUR","GBP","SGD","AED","AUD","CAD","CNY","SEK","NZD","MXN","BDT","EGP","HKD","INR","LBP","LKR","MAD","MYR","NGN","NPR","PHP","PKR","QAR","SAR","UZS","GHS"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-08-23 13:21:55','updated_at' => '2023-08-23 13:23:20','env' => 'SANDBOX'),
            array('id' => '13','slug' => 'add-money','code' => '142','type' => 'AUTOMATIC','name' => 'Flutterwave','title' => 'Flutterwave Payement Gateway','alias' => 'flutterwave','image' => '137701d0-4e12-4a21-bc63-cda5454c2476.webp','credentials' => '[{"label":"Encryption key","placeholder":"Enter Encryption key","name":"encryption-key","value":"FLWSECK_TEST27bee2235efd"},{"label":"Secret key","placeholder":"Enter Secret key","name":"secret-key","value":"FLWSECK_TEST-da35e3dbd28be1e7dc5d5f3519e2ebef-X"},{"label":"Public key","placeholder":"Enter Public key","name":"public-key","value":"FLWPUBK_TEST-e0bc02a00395b938a4a2bed65e1bc94f-X"}]','supported_currencies' => '["AED", "ARS", "AUD", "CAD", "CHF", "CZK", "ETB", "EUR", "GBP", "GHS", "ILS", "INR", "JPY", "KES", "MAD", "MUR", "MYR", "NGN", "NOK", "NZD", "PEN", "PLN", "RUB", "RWF", "SAR", "SEK", "SGD", "SLL", "TZS", "UGX", "USD", "XAF", "XOF", "ZAR", "ZMK", "ZMW", "MWK"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2023-05-25 11:40:27','updated_at' => '2023-05-30 18:42:59'),
            array('id' => '14','slug' => 'add-money','code' => '215','type' => 'AUTOMATIC','name' => 'QRPay','title' => 'QRPay Payment Gateway For Add Money','alias' => 'qrpay','image' => '7bcdead3-6b43-46db-8433-f15d5755827c.webp','credentials' => '[{"label":"Live Base Url","placeholder":"Enter Live Base Url","name":"live-base-url","value":"https:\\/\\/envato.appdevs.net\\/qrpay\\/pay\\/api\\/v1"},{"label":"Sendbox Base Url","placeholder":"Enter Sendbox Base Url","name":"sendbox-base-url","value":"https:\\/\\/envato.appdevs.net\\/qrpay\\/pay\\/sandbox\\/api\\/v1"},{"label":"Client Secret","placeholder":"Enter Client Secret","name":"client-secret","value":"oZouVmqHCbyg6ad7iMnrwq3d8wy9Kr4bo6VpQnsX6zAOoEs4oxHPjttpun36JhGxDl7AUMz3ShUqVyPmxh4oPk3TQmDF7YvHN5M3"},{"label":"Client Id","placeholder":"Enter Client Id","name":"client-id","value":"tRCDXCuztQzRYThPwlh1KXAYm4bG3rwWjbxM2R63kTefrGD2B9jNn6JnarDf7ycxdzfnaroxcyr5cnduY6AqpulRSebwHwRmGerA"}]','supported_currencies' => '["USD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-06 15:21:19','updated_at' => '2023-11-06 15:22:28'),
            array('id' => '15','slug' => 'add-money','code' => '220','type' => 'AUTOMATIC','name' => 'CoinGate','title' => 'Crypto Payment gateway (CoinGate)','alias' => 'coingate','image' => '7e1f09b8-7c58-44bb-9de5-133eaffc10eb.webp','credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/api-sandbox.coingate.com\\/v2"},{"label":"Sandbox App Token","placeholder":"Enter Sandbox App Token","name":"sandbox-app-token","value":"XJW4RyhT8F-xssX2PvaHMWJjYe5nsbsrbb2Uqy4m"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/api.coingate.com\\/v2"},{"label":"Production App Token","placeholder":"Enter Production App Token","name":"production-app-token","value":null}]','supported_currencies' => '["USD","BTC","LTC","ETH","BCH","TRX","ETC","DOGE","BTG","BNB","TUSD","USDT","BSV","MATIC","BUSD","SOL","WBTC","RVN","BCD","ATOM","BTTC","EURT"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => now(),'updated_at' => now()),
            array('id' => '16','slug' => 'add-money','code' => '225','type' => 'AUTOMATIC','name' => 'Tatum','title' => 'Tatum Gateway','alias' => 'tatum','image' => 'b6d31ae3-6b79-453a-a699-1c741b6cc0fe.webp','credentials' => '[{"label":"Testnet","placeholder":"Enter Testnet","name":"test-net","value":"t-657aafddb117a3001c86eda4-37941d61197f4aa6bf416aff"},{"label":"Mainnet","placeholder":"Enter Mainnet","name":"main-net","value":"t-657aafddb117a3001c86eda4-53dede7263974bb4a63d6e0e"}]','supported_currencies' => '["BTC","ETH","SOL"]','crypto' => '1','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => now(),'updated_at' => now()),
            array('id' => '17','slug' => 'add-money','code' => '230','type' => 'AUTOMATIC','name' => 'Perfect Money','title' => 'Perfect Money Gateway','alias' => 'perfect-money','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','credentials' => '[{"label":"Alternate Passphrase","placeholder":"Enter Alternate Passphrase","name":"alternate-passphrase","value":"t0d2nbK2ZA92fRTnIFsMTWsHT"},{"label":"EUR Account","placeholder":"Enter EUR Account","name":"eur-account","value":"E39620511"},{"label":"USD Account","placeholder":"Enter USD Account","name":"usd-account","value":"U39903302"}]','supported_currencies' => '["USD","EUR"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => now(),'updated_at' => now()),
            array('id' => '18','slug' => 'add-money','code' => '245','type' => 'AUTOMATIC','name' => 'Pagadito','title' => 'Pagadito Payment gateway','alias' => 'pagadito','image' => 'seeder/pagadito.webp','credentials' => '[{"label":"UID","placeholder":"Enter UID","name":"uid","value":"b73eb3fa1dc8bea4b4363322c906a8fd"},{"label":"WSK","placeholder":"Enter WSK","name":"wsk","value":"dc843ff5865bac2858ad8f23af081256"},{"label":"base_url","placeholder":"Enter base_url","name":"base_url","value":"https:\\/\\/sandbox.pagadito.com"}]','supported_currencies' => '["USD","HNL","CRC","DOP","GTQ","NIO","PAB"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' =>  now(),'updated_at' =>  now()),
            array('id' => '19','slug' => 'add-money','code' => '250','type' => 'AUTOMATIC','name' => 'Paystack','title' => 'Paystack Gateway','alias' => 'paystack','image' => 'seeder/paystack.webp','credentials' => '[{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"sk_test_d094bb8359027eab06ca8ea9a3b757e47e35684b"},{"label":"Public Key","placeholder":"Enter Public Key","name":"public-key","value":"pk_test_64a32791e5d7acc43acafb3646a1b9ce898519ea"}]','supported_currencies' => '["NGN","USD","GHS","ZAR","KES"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => now(),'updated_at' => now(),'env' => 'SANDBOX')


        );
          PaymentGateway::insert($payment_gateways);

        //gateway currency
        $payment_gateway_currencies = array(
        array('payment_gateway_id' => '1','name' => 'Paypal USD','alias' => 'add-money-paypal-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '1.00000000','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
        array('payment_gateway_id' => '1','name' => 'Paypal AUD','alias' => 'add-money-paypal-aud-automatic','currency_code' => 'AUD','currency_symbol' => '$','image' => NULL,'min_limit' => '15.00000000','max_limit' => '1500.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '1.55000000','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
        array('payment_gateway_id' => '2','name' => 'Stripe USD','alias' => 'add-money-stripe-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '1.00000000','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
        array('payment_gateway_id' => '2','name' => 'Stripe AUD','alias' => 'add-money-stripe-aud-automatic','currency_code' => 'AUD','currency_symbol' => '$','image' => NULL,'min_limit' => '15.00000000','max_limit' => '1500.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '1.55000000','created_at' => '2023-08-29 13:14:57','updated_at' => NULL),
        array('payment_gateway_id' => '3','name' => 'AdPay (Manual) USD','alias' => 'adpay-manual-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '1.00000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:36:51'),
        array('payment_gateway_id' => '4','name' => 'Bkash(Manual) BDT','alias' => 'bkashmanual-bdt-manual','currency_code' => 'BDT','currency_symbol' => '৳','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '109.13000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:14'),
        array('payment_gateway_id' => '5','name' => 'Khalti(Manual) NPR','alias' => 'khaltimanual-npr-manual','currency_code' => 'NPR','currency_symbol' => 'रु','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '132.05000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:33'),
        array('payment_gateway_id' => '6','name' => 'JazzCash(Manual) PKR','alias' => 'jazzcashmanual-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'रु','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '303.16000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:38:53'),
        array('payment_gateway_id' => '7','name' => 'EasyPaisa(Manual) PKR','alias' => 'easypaisamanual-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'रु','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '303.16000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:05'),
        array('payment_gateway_id' => '8','name' => 'PhonePe(Manual) INR','alias' => 'phonepemanual-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '82.67000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:17'),
        array('payment_gateway_id' => '9','name' => 'UPI(Manual) INR','alias' => 'upimanual-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '10.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '2.00000000','rate' => '82.67000000','created_at' => '2023-08-29 13:14:57','updated_at' => '2023-10-03 14:39:30'),
        array('payment_gateway_id' => '10','name' => 'StripCard(Manual) USD','alias' => 'stripcardmanual-usd-money-out','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '100.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-10-03 13:15:44','updated_at' => '2023-10-03 13:34:59'),
        array('payment_gateway_id' => '11','name' => 'SSLCommerz BDT','alias' => 'add-money-sslcommerz-bdt-automatic','currency_code' => 'BDT','currency_symbol' => '৳','image' => '06f617aa-a336-4382-987e-ae632929bed1.webp','min_limit' => '100.00000000','max_limit' => '50000.00000000','percent_charge' => '0.00000000','fixed_charge' => '0.00000000','rate' => '110.64000000','created_at' => '2023-10-03 17:27:49','updated_at' => '2023-10-03 17:29:55'),
        array('payment_gateway_id' => '12','name' => 'RazorPay INR','alias' => 'add-money-razorpay-inr-automatic','currency_code' => 'INR','currency_symbol' => '₹','image' => '69b7df34-f1fb-4947-a6f5-e93b78648075.webp','min_limit' => '100.00000000','max_limit' => '100000.00000000','percent_charge' => '0.00000000','fixed_charge' => '1.00000000','rate' => '82.87000000','created_at' => '2023-10-03 17:28:26','updated_at' => '2023-10-03 17:28:26'),
        array('payment_gateway_id' => '13','name' => 'Flutterwave NGN','alias' => 'add-money-flutterwave-ngn-automatic','currency_code' => 'NGN','currency_symbol' => '₦','image' => '17fb91c7-a29c-486a-ac5f-ca8bc69a1bfe.webp','min_limit' => '1000.00000000','max_limit' => '10000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '464.00000000','created_at' => '2023-10-03 17:29:06','updated_at' => '2023-10-03 17:29:06'),
        array('payment_gateway_id' => '14','name' => 'QRPay USD','alias' => 'add-money-qrpay-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '100.00000000','percent_charge' => '0.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-11-06 15:23:33','updated_at' => '2023-11-06 15:23:33'),
        array('payment_gateway_id' => '15','name' => 'CoinGate USDT','alias' => 'add-money-coingate-usdt-automatic','currency_code' => 'USDT','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '100.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '15','name' => 'CoinGate USD','alias' => 'add-money-coingate-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '100.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '16', 'name' => 'Tatum ETH','alias' => 'add-money-tatum-eth-automatic','currency_code' => 'ETH','currency_symbol' => 'ETH','image' => NULL,'min_limit' => '0.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '0.00044000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '16', 'name' => 'Tatum BTC','alias' => 'add-money-tatum-btc-automatic','currency_code' => 'BTC','currency_symbol' => 'BTC','image' => NULL,'min_limit' => '0.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '0.00002400','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '16', 'name' => 'Tatum SOL','alias' => 'add-money-tatum-sol-automatic','currency_code' => 'SOL','currency_symbol' => 'SOL','image' => NULL,'min_limit' => '0.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '3.76000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '17','name' => 'Perfect Money EUR','alias' => 'add-money-perfect-money-eur-automatic','currency_code' => 'EUR','currency_symbol' => '€','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '0.92000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '17','name' => 'Perfect Money USD','alias' => 'add-money-perfect-money-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'a9f5fc3e-b53c-4fb8-9b9d-301c82b3158c.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay GHS','alias' => 'add-money-razorpay-ghs-automatic','currency_code' => 'GHS','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '11.90000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay UZS','alias' => 'add-money-razorpay-uzs-automatic','currency_code' => 'UZS','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '12263.46000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay SAR','alias' => 'add-money-razorpay-sar-automatic','currency_code' => 'SAR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.75000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay QAR','alias' => 'add-money-razorpay-qar-automatic','currency_code' => 'QAR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.64000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay PKR','alias' => 'add-money-razorpay-pkr-automatic','currency_code' => 'PKR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '286.50000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay PHP','alias' => 'add-money-razorpay-php-automatic','currency_code' => 'PHP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '55.79000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay NPR','alias' => 'add-money-razorpay-npr-automatic','currency_code' => 'NPR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '133.25000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay NGN','alias' => 'add-money-razorpay-ngn-automatic','currency_code' => 'NGN','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '780.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay MYR','alias' => 'add-money-razorpay-myr-automatic','currency_code' => 'MYR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '4.69000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay MAD','alias' => 'add-money-razorpay-mad-automatic','currency_code' => 'MAD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '10.21000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay LKR','alias' => 'add-money-razorpay-lkr-automatic','currency_code' => 'LKR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '327.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay LBP','alias' => 'add-money-razorpay-lbp-automatic','currency_code' => 'LBP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '15000.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay HKD','alias' => 'add-money-razorpay-hkd-automatic','currency_code' => 'HKD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '7.81000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay EGP','alias' => 'add-money-razorpay-egp-automatic','currency_code' => 'EGP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '30.85000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay BDT','alias' => 'add-money-razorpay-bdt-automatic','currency_code' => 'BDT','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '110.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay MXN','alias' => 'add-money-razorpay-mxn-automatic','currency_code' => 'MXN','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '17.57000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay NZD','alias' => 'add-money-razorpay-nzd-automatic','currency_code' => 'NZD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.69000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay SEK','alias' => 'add-money-razorpay-sek-automatic','currency_code' => 'SEK','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '10.89000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay CNY','alias' => 'add-money-razorpay-cny-automatic','currency_code' => 'CNY','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '7.29000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay CAD','alias' => 'add-money-razorpay-cad-automatic','currency_code' => 'CAD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.38000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay AUD','alias' => 'add-money-razorpay-aud-automatic','currency_code' => 'AUD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.56000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay AED','alias' => 'add-money-razorpay-aed-automatic','currency_code' => 'AED','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '3.67000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay SGD','alias' => 'add-money-razorpay-sgd-automatic','currency_code' => 'SGD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.36000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay GBP','alias' => 'add-money-razorpay-gbp-automatic','currency_code' => 'GBP','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '0.82000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay EUR','alias' => 'add-money-razorpay-eur-automatic','currency_code' => 'EUR','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '0.94000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '12','name' => 'Razorpay USD','alias' => 'add-money-razorpay-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '2.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '18','name' => 'Pagadito USD','alias' => 'add-money-pagadito-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito HNL','alias' => 'add-money-pagadito-hnl-automatic','currency_code' => 'HNL','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '0.00000000','max_limit' => '0.00000000','percent_charge' => '0.00000000','fixed_charge' => '0.00000000','rate' => '24.62000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito CRC','alias' => 'add-money-pagadito-crc-automatic','currency_code' => 'CRC','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '518.12000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito DOP','alias' => 'add-money-pagadito-dop-automatic','currency_code' => 'DOP','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '58.02801200','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito GTQ','alias' => 'add-money-pagadito-gtq-automatic','currency_code' => 'GTQ','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '7.81000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito NIO','alias' => 'add-money-pagadito-nio-automatic','currency_code' => 'NIO','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '36.54000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),
        array('payment_gateway_id' => '18','name' => 'Pagadito PAB','alias' => 'add-money-pagadito-pab-automatic','currency_code' => 'PAB','currency_symbol' => NULL,'image' => 'seeder/pagadito.webp','min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2024-01-08 04:11:48','updated_at' => '2024-01-08 04:12:21'),

        array('payment_gateway_id' => '19','name' => 'Paystack NGN','alias' => 'add-money-paystack-ngn-automatic','currency_code' => 'NGN','currency_symbol' => '₦','image' => NULL,'min_limit' => '1589.33000000','max_limit' => '10000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '1589.33000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '19','name' => 'Paystack USD','alias' => 'add-money-paystack-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '1.00000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '19','name' => 'Paystack GHS','alias' => 'add-money-paystack-ghs-automatic','currency_code' => 'GHS','currency_symbol' => 'GH₵','image' => NULL,'min_limit' => '15.62000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '15.62000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '19','name' => 'Paystack ZAR','alias' => 'add-money-paystack-zar-automatic','currency_code' => 'ZAR','currency_symbol' => 'R','image' => NULL,'min_limit' => '17.72000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '17.72000000','created_at' => now(),'updated_at' => now()),
        array('payment_gateway_id' => '19','name' => 'Paystack KES','alias' => 'add-money-paystack-kes-automatic','currency_code' => 'KES','currency_symbol' => 'KSh','image' => NULL,'min_limit' => '129.00000000','max_limit' => '1000.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '129.00000000','created_at' => now(),'updated_at' => now())


    );
        PaymentGatewayCurrency::insert($payment_gateway_currencies);

    }
}
