<?php

namespace Database\Seeders\Admin;

use App\Constants\GlobalConst;
use App\Models\Admin\SetupPage;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SetupPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $pages =  ["Home" => "/","About" => "/about","Services"=>"/services","Announcement" =>"announcement","Contact" => "/contact"];
        $data = [];
        foreach($pages as $item => $url) {
            $data[] = [
                'type'         => Str::slug(GlobalConst::SETUP_PAGE),
                'slug'         => Str::slug($item),
                'title'        => json_encode(
                    [
                        'title'     => $item
                    ],
                ),
                'url'          => $url,
                'last_edit_by' => 1,
                'status' => 1,
                'created_at'   => now(),
            ];
        }
        SetupPage::truncate();
        SetupPage::insert($data);


        //usefull link
        $setup_pages = array(
            array('id' => '6','type' => 'useful-links','slug' => 'privacy-policy','title' => '{"language":{"en":{"title":"Privacy Policy"},"es":{"title":"pol\\u00edtica de privacidad"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629"},"fr":{"title":"politique de confidentialit\\u00e9"},"hi":{"title":"\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f"}}}','url' => NULL,'details' => '{"language":{"en":{"details":"<h3 style=\\"margin-left:0px;\\"><strong>What information do we collect?<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">We gather data from you when you register on our site, submit a request, buy any services, react to an overview, or round out a structure. At the point when requesting any assistance or enrolling on our site, as suitable, you might be approached to enter your: name, email address, or telephone number. You may, nonetheless, visit our site anonymously.<\\/p><h3 style=\\"margin-left:0px;\\"><strong>How do we protect your information?<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">All provided delicate\\/credit data is sent through Stripe.<br>After an exchange, your private data (credit cards, social security numbers, financials, and so on) won be put away on our workers.<\\/p><h3 style=\\"margin-left:0px;\\"><strong>Do we disclose any information to outside parties?<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">We don sell, exchange, or in any case move to outside gatherings by and by recognizable data. This does exclude confided in outsiders who help us in working our site, leading our business, or adjusting you, since those gatherings consent to keep this data private. We may likewise deliver your data when we accept discharge is suitable to follow the law, implement our site strategies, or ensure our own or others rights, property, or wellbeing.<\\/p><h3 style=\\"margin-left:0px;\\"><strong>Childrens Online Privacy Protection Act Compliance<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">We are consistent with the prerequisites of COPPA (Childrens Online Privacy Protection Act), we don gather any data from anybody under 13 years old. Our site, items, and administrations are completely coordinated to individuals who are in any event 13 years of age or more established.<\\/p><h3 style=\\"margin-left:0px;\\"><strong>Changes to our Privacy Policy<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">If we decide to change our privacy policy, we will post those changes on this page.<\\/p><h3 style=\\"margin-left:0px;\\"><strong>How long we retain your information?<\\/strong><\\/h3><p style=\\"margin-left:0px;\\">At the point when you register for our site, we cycle and keep your information we have about you however long you don not erase the record or withdraw yourself (subject to laws and guidelines).<\\/p><h2 style=\\"margin-left:0px;text-align:center;\\">&nbsp;<\\/h2>"},"es":{"details":"<p>\\u00bfQu\\u00e9 informaci\\u00f3n recopilamos?<\\/p><p>Recopilamos sus datos cuando se registra en nuestro sitio, env\\u00eda una solicitud, compra cualquier servicio, reacciona a una descripci\\u00f3n general o completa una estructura. Cuando solicite asistencia o se registre en nuestro sitio, seg\\u00fan corresponda, se le pedir\\u00e1 que ingrese su: nombre, direcci\\u00f3n de correo electr\\u00f3nico o n\\u00famero de tel\\u00e9fono. No obstante, puede visitar nuestro sitio de forma an\\u00f3nima.<\\/p><p>\\u00bfC\\u00f3mo protegemos tu informaci\\u00f3n?<\\/p><p>Todos los datos delicados\\/de cr\\u00e9dito proporcionados se env\\u00edan a trav\\u00e9s de Stripe.<br>Despu\\u00e9s de un intercambio, sus datos privados (tarjetas de cr\\u00e9dito, n\\u00fameros de seguridad social, datos financieros, etc.) se guardar\\u00e1n en nuestros trabajadores.<\\/p><p>\\u00bfRevelamos informaci\\u00f3n a terceros?<\\/p><p>No vendemos, intercambiamos o, en cualquier caso, nos trasladamos a reuniones externas por y por datos reconocibles. Esto excluye a personas ajenas a la confianza que nos ayudan a trabajar en nuestro sitio, liderar nuestro negocio o ajustarlo, ya que esos grupos aceptan mantener estos datos privados. Tambi\\u00e9n podemos entregar sus datos cuando aceptemos que la descarga es adecuada para cumplir con la ley, implementar las estrategias de nuestro sitio o garantizar nuestros derechos, propiedad o bienestar propios o ajenos.<\\/p><p>Cumplimiento de la Ley de protecci\\u00f3n de la privacidad en l\\u00ednea de los ni\\u00f1os<\\/p><p>Cumplimos con los requisitos previos de COPPA (Ley de protecci\\u00f3n de la privacidad en l\\u00ednea de los ni\\u00f1os), no recopilamos datos de personas menores de 13 a\\u00f1os. Nuestro sitio, art\\u00edculos y administraciones est\\u00e1n completamente coordinados para personas que tienen al menos 13 a\\u00f1os de edad o m\\u00e1s establecidas.<\\/p><p>Cambios a nuestra Pol\\u00edtica de Privacidad<\\/p><p>Si decidimos cambiar nuestra pol\\u00edtica de privacidad, publicaremos esos cambios en esta p\\u00e1gina.<\\/p><p>\\u00bfCu\\u00e1nto tiempo retenemos su informaci\\u00f3n?<\\/p><p>En el momento en que se registra en nuestro sitio, ciclamos y mantenemos la informaci\\u00f3n que tenemos sobre usted por el tiempo que no borre el registro o se retire (sujeto a leyes y pautas).<\\/p>"},"ar":{"details":"<p>\\u0645\\u0627 \\u0647\\u064a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627\\u061f<\\/p><p>\\u0646\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0645\\u0646\\u0643 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u0633\\u062c\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627\\u060c \\u0623\\u0648 \\u062a\\u0642\\u062f\\u0645 \\u0637\\u0644\\u0628\\u064b\\u0627\\u060c \\u0623\\u0648 \\u062a\\u0634\\u062a\\u0631\\u064a \\u0623\\u064a \\u062e\\u062f\\u0645\\u0627\\u062a\\u060c \\u0623\\u0648 \\u062a\\u0633\\u062a\\u062c\\u064a\\u0628 \\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629\\u060c \\u0623\\u0648 \\u062a\\u0643\\u0645\\u0644 \\u0647\\u064a\\u0643\\u0644\\u064b\\u0627. \\u0639\\u0646\\u062f \\u0637\\u0644\\u0628 \\u0623\\u064a \\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627\\u060c \\u062d\\u0633\\u0628 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0636\\u0627\\u0621\\u060c \\u0642\\u062f \\u064a\\u064f\\u0637\\u0644\\u0628 \\u0645\\u0646\\u0643 \\u0625\\u062f\\u062e\\u0627\\u0644: \\u0627\\u0633\\u0645\\u0643\\u060c \\u0623\\u0648 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0628\\u0631\\u064a\\u062f\\u0643 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u060c \\u0623\\u0648 \\u0631\\u0642\\u0645 \\u0647\\u0627\\u062a\\u0641\\u0643. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0628\\u0634\\u0643\\u0644 \\u0645\\u062c\\u0647\\u0648\\u0644.<\\/p><p>\\u0643\\u064a\\u0641 \\u0646\\u062d\\u0645\\u064a \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643\\u061f<\\/p><p>\\u064a\\u062a\\u0645 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062d\\u0633\\u0627\\u0633\\u0629\\/\\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 Stripe.<br>\\u0628\\u0639\\u062f \\u0627\\u0644\\u062a\\u0628\\u0627\\u062f\\u0644\\u060c \\u0644\\u0646 \\u064a\\u062a\\u0645 \\u062a\\u062e\\u0632\\u064a\\u0646 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 (\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u060c \\u0648\\u0623\\u0631\\u0642\\u0627\\u0645 \\u0627\\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u064a\\u060c \\u0648\\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629\\u060c \\u0648\\u0645\\u0627 \\u0625\\u0644\\u0649 \\u0630\\u0644\\u0643) \\u0644\\u062f\\u0649 \\u0645\\u0648\\u0638\\u0641\\u064a\\u0646\\u0627.<\\/p><p>\\u0647\\u0644 \\u0646\\u0641\\u0635\\u062d \\u0639\\u0646 \\u0623\\u064a \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u062e\\u0627\\u0631\\u062c\\u064a\\u0629\\u061f<\\/p><p>\\u0644\\u0627 \\u0646\\u0628\\u064a\\u0639 \\u0623\\u0648 \\u0646\\u062a\\u0628\\u0627\\u062f\\u0644 \\u0623\\u0648 \\u0646\\u0646\\u0642\\u0644 \\u0625\\u0644\\u0649 \\u0623\\u0637\\u0631\\u0627\\u0641 \\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0628\\u0623\\u064a \\u062d\\u0627\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u062d\\u0648\\u0627\\u0644 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u064a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u064a\\u0647\\u0627 \\u0634\\u062e\\u0635\\u064a\\u064b\\u0627. \\u0648\\u0647\\u0630\\u0627 \\u064a\\u0633\\u062a\\u062b\\u0646\\u064a \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0648\\u062b\\u0648\\u0642 \\u0628\\u0647\\u0627 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0641\\u064a \\u062a\\u0634\\u063a\\u064a\\u0644 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627\\u060c \\u0623\\u0648 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0623\\u0639\\u0645\\u0627\\u0644\\u0646\\u0627\\u060c \\u0623\\u0648 \\u062a\\u0639\\u062f\\u064a\\u0644\\u0643\\u060c \\u0644\\u0623\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0625\\u0628\\u0642\\u0627\\u0621 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u062e\\u0627\\u0635\\u0629. \\u064a\\u062c\\u0648\\u0632 \\u0644\\u0646\\u0627 \\u0623\\u064a\\u0636\\u064b\\u0627 \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u0646\\u0639\\u062a\\u0642\\u062f \\u0623\\u0646 \\u0627\\u0644\\u0625\\u0641\\u0631\\u0627\\u062c \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0644\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u060c \\u0623\\u0648 \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0633\\u062a\\u0631\\u0627\\u062a\\u064a\\u062c\\u064a\\u0627\\u062a \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627\\u060c \\u0623\\u0648 \\u0636\\u0645\\u0627\\u0646 \\u062d\\u0642\\u0648\\u0642\\u0646\\u0627 \\u0623\\u0648 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0622\\u062e\\u0631\\u064a\\u0646 \\u0623\\u0648 \\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a\\u0646\\u0627 \\u0623\\u0648 \\u0633\\u0644\\u0627\\u0645\\u062a\\u0646\\u0627.<\\/p><p>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a<\\/p><p>\\u0646\\u062d\\u0646 \\u0645\\u062a\\u0648\\u0627\\u0641\\u0642\\u0648\\u0646 \\u0645\\u0639 \\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a (COPPA)\\u060c \\u0648\\u0644\\u0627 \\u0646\\u062c\\u0645\\u0639 \\u0623\\u064a \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0645\\u0646 \\u0623\\u064a \\u0634\\u062e\\u0635 \\u064a\\u0642\\u0644 \\u0639\\u0645\\u0631\\u0647 \\u0639\\u0646 13 \\u0639\\u0627\\u0645\\u064b\\u0627. \\u064a\\u062a\\u0645 \\u062a\\u0648\\u062c\\u064a\\u0647 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0648\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a\\u0646\\u0627 \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627 \\u0628\\u0627\\u0644\\u0643\\u0627\\u0645\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0634\\u062e\\u0627\\u0635 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u0628\\u0644\\u063a\\u0648\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0631 13 \\u0639\\u0627\\u0645\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0642\\u0644 \\u0623\\u0648 \\u0623\\u0643\\u062b\\u0631.<\\/p><p>\\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0646\\u0627<\\/p><p>\\u0625\\u0630\\u0627 \\u0642\\u0631\\u0631\\u0646\\u0627 \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0646\\u0627\\u060c \\u0641\\u0633\\u0646\\u0646\\u0634\\u0631 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0629.<\\/p><p>\\u0625\\u0644\\u0649 \\u0645\\u062a\\u0649 \\u0646\\u062d\\u062a\\u0641\\u0638 \\u0628\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643\\u061f<\\/p><p>\\u0639\\u0646\\u062f \\u062a\\u0633\\u062c\\u064a\\u0644\\u0643 \\u0641\\u064a \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627\\u060c \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062f\\u0648\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0639\\u0646\\u0643 \\u0648\\u0627\\u0644\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0628\\u0647\\u0627 \\u0637\\u0627\\u0644\\u0645\\u0627 \\u0644\\u0645 \\u062a\\u0642\\u0645 \\u0628\\u062d\\u0630\\u0641 \\u0627\\u0644\\u0633\\u062c\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0646\\u0633\\u062d\\u0627\\u0628 \\u0628\\u0646\\u0641\\u0633\\u0643 (\\u0648\\u0641\\u0642\\u064b\\u0627 \\u0644\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a).<\\/p>"},"fr":{"details":"<p>Quelles informations collectons-nous ?<\\/p><p>Nous collectons des donn\\u00e9es vous concernant lorsque vous vous inscrivez sur notre site, soumettez une demande, achetez des services, r\\u00e9pondez \\u00e0 un avis ou compl\\u00e9tez un formulaire. Lorsque vous demandez de l\'aide ou vous inscrivez sur notre site, selon le cas, il peut vous \\u00eatre demand\\u00e9 de saisir votre nom, votre adresse e-mail ou votre num\\u00e9ro de t\\u00e9l\\u00e9phone. Vous pouvez n\\u00e9anmoins visiter notre site de mani\\u00e8re anonyme.<\\/p><p>Comment prot\\u00e9geons-nous vos informations ?<\\/p><p>Toutes les donn\\u00e9es sensibles\\/de cr\\u00e9dit fournies sont envoy\\u00e9es via Stripe.<br>Apr\\u00e8s un \\u00e9change, vos donn\\u00e9es personnelles (cartes de cr\\u00e9dit, num\\u00e9ros de s\\u00e9curit\\u00e9 sociale, donn\\u00e9es financi\\u00e8res, etc.) seront stock\\u00e9es chez nos employ\\u00e9s.<\\/p><p>Divulguons-nous des informations \\u00e0 des tiers ?<\\/p><p>Nous ne vendons, n\'\\u00e9changeons ni ne transmettons en aucun cas \\u00e0 des tiers des informations personnellement identifiables. Cela n\'exclut pas les tiers de confiance qui nous aident \\u00e0 exploiter notre site, \\u00e0 diriger notre entreprise ou \\u00e0 vous entretenir, car ces tiers acceptent de garder ces donn\\u00e9es priv\\u00e9es. Nous pouvons \\u00e9galement divulguer vos donn\\u00e9es lorsque nous consid\\u00e9rons que la divulgation est appropri\\u00e9e pour respecter la loi, mettre en \\u0153uvre les strat\\u00e9gies de notre site ou garantir nos droits, notre propri\\u00e9t\\u00e9 ou notre s\\u00e9curit\\u00e9 ou ceux d\'autrui.<\\/p><p>Conformit\\u00e9 \\u00e0 la loi sur la protection de la vie priv\\u00e9e des enfants en ligne<\\/p><p>Nous sommes conformes aux exigences de la COPPA (Childrens Online Privacy Protection Act), nous ne collectons aucune donn\\u00e9e de toute personne de moins de 13 ans. Notre site, nos produits et nos services sont enti\\u00e8rement adapt\\u00e9s aux personnes \\u00e2g\\u00e9es de 13 ans ou plus.<\\/p><p>Modifications de notre politique de confidentialit\\u00e9<\\/p><p>Si nous d\\u00e9cidons de modifier notre politique de confidentialit\\u00e9, nous publierons ces modifications sur cette page.<\\/p><p>Combien de temps conservons-nous vos informations ?<\\/p><p>Lorsque vous vous inscrivez sur notre site, nous recyclons et conservons les informations que nous avons sur vous tant que vous ne supprimez pas votre compte ou ne vous d\\u00e9sinscrivez pas (sous r\\u00e9serve des lois et r\\u00e9glementations).<\\/p>"},"hi":{"details":"<p>\\u0939\\u092e \\u0915\\u094c\\u0928 \\u0938\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902?<\\/p><p>\\u091c\\u092c \\u0906\\u092a \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u092a\\u0930 \\u092a\\u0902\\u091c\\u0940\\u0915\\u0930\\u0923 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0915\\u094b\\u0908 \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0938\\u092c\\u092e\\u093f\\u091f \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0915\\u094b\\u0908 \\u0938\\u0947\\u0935\\u093e \\u0916\\u0930\\u0940\\u0926\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0915\\u093f\\u0938\\u0940 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u092a\\u0930 \\u092a\\u094d\\u0930\\u0924\\u093f\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u092f\\u093e \\u0915\\u094b\\u0908 \\u092b\\u0949\\u0930\\u094d\\u092e \\u092d\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0939\\u092e \\u0906\\u092a\\u0938\\u0947 \\u0921\\u0947\\u091f\\u093e \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0915\\u093e \\u0905\\u0928\\u0941\\u0930\\u094b\\u0927 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f \\u092f\\u093e \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u092a\\u0930 \\u0928\\u093e\\u092e\\u093e\\u0902\\u0915\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f, \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0939\\u094b\\u0928\\u0947 \\u092a\\u0930, \\u0906\\u092a\\u0938\\u0947 \\u0905\\u092a\\u0928\\u093e \\u0928\\u093e\\u092e, \\u0908\\u092e\\u0947\\u0932 \\u092a\\u0924\\u093e \\u092f\\u093e \\u092b\\u093c\\u094b\\u0928 \\u0928\\u0902\\u092c\\u0930 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u0939\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0901\\u0915\\u093f, \\u0906\\u092a \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u092a\\u0930 \\u0917\\u0941\\u092e\\u0928\\u093e\\u092e \\u0930\\u0942\\u092a \\u0938\\u0947 \\u091c\\u093e \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p><p>\\u0939\\u092e \\u0906\\u092a\\u0915\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902?<\\/p><p>\\u0938\\u092d\\u0940 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0940 \\u0917\\u0908 \\u0938\\u0902\\u0935\\u0947\\u0926\\u0928\\u0936\\u0940\\u0932\\/\\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 Stripe \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u092d\\u0947\\u091c\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p><p>\\u0915\\u093f\\u0938\\u0940 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u092c\\u093e\\u0926, \\u0906\\u092a\\u0915\\u0940 \\u0928\\u093f\\u091c\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 (\\u0915\\u094d\\u0930\\u0947\\u0921\\u093f\\u091f \\u0915\\u093e\\u0930\\u094d\\u0921, \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0928\\u0902\\u092c\\u0930, \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0935\\u093f\\u0935\\u0930\\u0923, \\u0907\\u0924\\u094d\\u092f\\u093e\\u0926\\u093f) \\u0939\\u092e\\u093e\\u0930\\u0947 \\u0915\\u0930\\u094d\\u092e\\u091a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0930\\u0939\\u0947\\u0917\\u0940\\u0964<\\/p><p>\\u0915\\u094d\\u092f\\u093e \\u0939\\u092e \\u092c\\u093e\\u0939\\u0930\\u0940 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0915\\u094b\\u0908 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902?<\\/p><p>\\u0939\\u092e \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092a\\u0939\\u091a\\u093e\\u0928 \\u092f\\u094b\\u0917\\u094d\\u092f \\u0921\\u0947\\u091f\\u093e \\u0915\\u094b \\u092c\\u0947\\u091a\\u0924\\u0947, \\u090f\\u0915\\u094d\\u0938\\u091a\\u0947\\u0902\\u091c \\u0915\\u0930\\u0924\\u0947 \\u092f\\u093e \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u092e\\u093e\\u092e\\u0932\\u0947 \\u092e\\u0947\\u0902 \\u092c\\u093e\\u0939\\u0930\\u0940 \\u0938\\u092e\\u0942\\u0939\\u094b\\u0902 \\u0915\\u094b \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092d\\u0930\\u094b\\u0938\\u0947\\u092e\\u0902\\u0926 \\u092c\\u093e\\u0939\\u0930\\u0940 \\u0932\\u094b\\u0917 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u0915\\u094b \\u091a\\u0932\\u093e\\u0928\\u0947, \\u0939\\u092e\\u093e\\u0930\\u0947 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f \\u0915\\u093e \\u0928\\u0947\\u0924\\u0943\\u0924\\u094d\\u0935 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0906\\u092a\\u0915\\u094b \\u0938\\u092e\\u093e\\u092f\\u094b\\u091c\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0915\\u094d\\u092f\\u094b\\u0902\\u0915\\u093f \\u0935\\u0947 \\u0938\\u092e\\u0942\\u0939 \\u0907\\u0938 \\u0921\\u0947\\u091f\\u093e \\u0915\\u094b \\u0928\\u093f\\u091c\\u0940 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0939\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0939\\u092e \\u0906\\u092a\\u0915\\u093e \\u0921\\u0947\\u091f\\u093e \\u0924\\u092c \\u092d\\u0940 \\u0921\\u093f\\u0932\\u0940\\u0935\\u0930 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u092c \\u0939\\u092e \\u092e\\u093e\\u0928\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0915\\u093f \\u0921\\u093f\\u0938\\u094d\\u091a\\u093e\\u0930\\u094d\\u091c \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947, \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u0930\\u0923\\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0928\\u0947, \\u092f\\u093e \\u0905\\u092a\\u0928\\u0947 \\u092f\\u093e \\u0926\\u0942\\u0938\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902, \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u092f\\u093e \\u0915\\u0932\\u094d\\u092f\\u093e\\u0923 \\u0915\\u094b \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0939\\u0948\\u0964<\\/p><p>\\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0940 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0905\\u0927\\u093f\\u0928\\u093f\\u092f\\u092e \\u0915\\u093e \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928<\\/p><p>\\u0939\\u092e COPPA (\\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0940 \\u0911\\u0928\\u0932\\u093e\\u0907\\u0928 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0905\\u0927\\u093f\\u0928\\u093f\\u092f\\u092e) \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0905\\u0928\\u0941\\u0930\\u0942\\u092a \\u0939\\u0948\\u0902, \\u0939\\u092e 13 \\u0935\\u0930\\u094d\\u0937 \\u0938\\u0947 \\u0915\\u092e \\u0909\\u092e\\u094d\\u0930 \\u0915\\u0947 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0938\\u0947 \\u0915\\u094b\\u0908 \\u092d\\u0940 \\u0921\\u0947\\u091f\\u093e \\u090f\\u0915\\u0924\\u094d\\u0930 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f, \\u0906\\u0907\\u091f\\u092e \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928 \\u092a\\u0942\\u0930\\u0940 \\u0924\\u0930\\u0939 \\u0938\\u0947 \\u0909\\u0928 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u092e\\u0928\\u094d\\u0935\\u093f\\u0924 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0915\\u092e \\u0938\\u0947 \\u0915\\u092e 13 \\u0935\\u0930\\u094d\\u0937 \\u092f\\u093e \\u0909\\u0938\\u0938\\u0947 \\u0905\\u0927\\u093f\\u0915 \\u0909\\u092e\\u094d\\u0930 \\u0915\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p><p>\\u0939\\u092e\\u093e\\u0930\\u0940 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u092e\\u0947\\u0902 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u0928<\\/p><p>\\u092f\\u0926\\u093f \\u0939\\u092e \\u0905\\u092a\\u0928\\u0940 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0928\\u0940\\u0924\\u093f \\u0915\\u094b \\u092c\\u0926\\u0932\\u0928\\u0947 \\u0915\\u093e \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0932\\u0947\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0939\\u092e \\u0909\\u0928 \\u092a\\u0930\\u093f\\u0935\\u0930\\u094d\\u0924\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0907\\u0938 \\u092a\\u0943\\u0937\\u094d\\u0920 \\u092a\\u0930 \\u092a\\u094b\\u0938\\u094d\\u091f \\u0915\\u0930\\u0947\\u0902\\u0917\\u0947\\u0964<\\/p><p>\\u0939\\u092e \\u0906\\u092a\\u0915\\u0940 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u092c \\u0924\\u0915 \\u0930\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902?<\\/p><p>\\u091c\\u092c \\u0906\\u092a \\u0939\\u092e\\u093e\\u0930\\u0940 \\u0938\\u093e\\u0907\\u091f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u0902\\u091c\\u0940\\u0915\\u0930\\u0923 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0924\\u094b \\u0939\\u092e \\u0906\\u092a\\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0906\\u092a\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u092e\\u094c\\u091c\\u0942\\u0926 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u094b \\u0924\\u092c \\u0924\\u0915 \\u091a\\u0915\\u094d\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0930\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u091c\\u092c \\u0924\\u0915 \\u0906\\u092a \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0915\\u094b \\u092e\\u093f\\u091f\\u093e \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0947\\u0924\\u0947 \\u092f\\u093e \\u0916\\u0941\\u0926 \\u0915\\u094b \\u0935\\u093e\\u092a\\u0938 \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947 \\u0932\\u0947\\u0924\\u0947 (\\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u0940\\u0928)\\u0964<\\/p>"}}}','last_edit_by' => '1','status' => '1','created_at' => '2024-11-13 18:24:19','updated_at' => '2024-11-15 16:24:06')
        );

        SetupPage::insert($setup_pages);

    }
}
