<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="body-wrapper">
        <div class="row mb-30-none">
            <div class="col-xl-6 mb-30">
                <div class="dash-payment-item-wrapper">
                    <div class="dash-payment-item active">

                        <div class="card-body">
                            <form class="card-form">
                                <div class="row">
                                    <div class="col-xl-12 col-lg-12 form-group">
                                        <label><?php echo e(__($page_title)); ?></label>
                                        <div class="input-group">
                                            <input type="text" class="form--control" id="referralURL" value="<?php echo e(auth()->user()->two_factor_secret); ?>" readonly>
                                            <div class="input-group-text copytext" id="copyBoard"><i class="las la-copy"></i></div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 form-group">
                                        <div class="qr-code-thumb text-center">
                                            <img class="mx-auto" src="<?php echo e($qr_code); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-12">
                                <?php if(auth()->user()->two_factor_status): ?>
                                    <button type="button" class="btn--base bg--warning w-100 active-deactive-btn"><?php echo e(__("Disable")); ?></button>
                                    <br>
                                    <div class="text--danger mt-3"><?php echo e(__("Don't forget to add this application in your google authentication app. Otherwise you can't login in your account.")); ?></div>
                                <?php else: ?>
                                    <button type="button" class="btn--base w-100 active-deactive-btn"><?php echo e(__("Enable")); ?></button>
                                <?php endif; ?>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 mb-30">
                <div class="dash-payment-item-wrapper">
                    <div class="dash-payment-item active">
                        <div class="card-body">
                            <h4 class="mb-3"><?php echo e(__("Download Google Authenticator App")); ?></h4>
                            <p><?php echo e(__("Google Authenticator is a product based authenticator by Google that executes two-venture confirmation administrations for verifying clients of any programming applications")); ?>.</p>
                            <div class="play-store-thumb text-center pb-20">
                                <img class="mx-auto" src="<?php echo e(asset('public/frontend/')); ?>/images/element/google-authenticator.webp">
                            </div>
                            <a href="https://play.google.com/store/apps" target="_blank" class="btn--base mt-10 w-100"><?php echo e(__("Download App")); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(".active-deactive-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('user.security.google.2fa.status.update')); ?>";
            var target      = 1;
            var btnText = $(this).text();
            var sureText = '<?php echo e(__("Are you sure to")); ?>';
            var lastText = '<?php echo e(__("2 factor authentication (Powered by google)")); ?>';
            var message     = `${sureText} <strong>${btnText}</strong> ${lastText}?`;
            openAlertModal(actionRoute,target,message,btnText,"POST");
        });
        $('.copytext').on('click',function(){
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");

            throwMessage('success',["<?php echo e(__('Copied')); ?>: " + copyText.value]);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/user/sections/security/google-2fa.blade.php ENDPATH**/ ?>