

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Support Ticket")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.components.support-ticket.counter-card',['support_tickets' => $support_tickets], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="table-area mt-15">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__("All Ticket")); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__("Ticket ID")); ?></th>
                            <th><?php echo e(__("Subject")); ?></th>
                            <th><?php echo e(__("User (Fullname)")); ?></th>
                            <th><?php echo e(__("Email")); ?></th>
                            <th><?php echo e(__("Status")); ?></th>
                            <th><?php echo e(__("Last Replied")); ?></th>
                            <th><?php echo e(__("Details")); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $support_tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>#<?php echo e($item->token); ?></td>
                                <td>
                                    <?php if($item->status == support_ticket_const()::DEFAULT): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::SOLVED): ?>
                                        <span class="text--success"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::ACTIVE): ?>
                                        <span class="text--primary"><?php echo e($item->subject); ?></span>
                                    <?php elseif($item->status == support_ticket_const()::PENDING): ?>
                                        <span class="text--warning"><?php echo e($item->subject); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($item->user->fullname); ?>

                                </td>
                                <td><?php echo e($item->email); ?></td>
                                <td>
                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e($item->stringStatus->value); ?></span>
                                </td>
                                <td>
                                    <?php if(count($item->conversations) > 0): ?>
                                        <?php echo e($item->conversations->last()->created_at->format("Y-m-d H:i A") ?? ""); ?></td>
                                    <?php endif; ?>
                                <td>
                                    <a href="<?php echo e(setRoute('admin.support.ticket.conversation',encrypt($item->id))); ?>" class="btn btn--base"><i class="las la-comment"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 9], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp 8.0.2\htdocs\strip_card\v3.5.0\full_project\resources\views/admin/sections/support-ticket/index.blade.php ENDPATH**/ ?>