<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Add Money Details'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="custom-card">
    <div class="card-header">
        <h6 class="title"><?php echo e(__("Add Money Details")); ?></h6>
    </div>
    <div class="card-body">
        <form class="card-form">
            <div class="row align-items-center mb-10-none">
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list-two">
                        <li class="one"><?php echo e(__("Date")); ?>: <span><?php echo e(@$data->created_at->format('d-m-y h:i:s A')); ?></span></li>
                        <li class="two"><?php echo e(__("TRX ID")); ?>: <span><?php echo e(@$data->trx_id); ?></span></li>
                        <li class="three"><?php echo e(__("Username")); ?>: <span><a href="<?php echo e(setRoute('admin.users.details',@$data->user->username)); ?>"><?php echo e(@$data->user->username); ?></a></span></li>
                        <li class="four"><?php echo e(__("Method")); ?>: <span><?php echo e(@$data->currency->name); ?></span></li>
                        <li class="five"><?php echo e(__("Amount")); ?>: <span><?php echo e(number_format(@$data->request_amount,2)); ?> <?php echo e(get_default_currency_code()); ?></span></li>
                    </ul>
                </div>

                <div class="col-xl-4 col-lg-4 form-group">
                    <div class="user-profile-thumb">
                        <img src="<?php echo e(get_gateway_image($data->currency->payment_gateway_id)); ?>" alt="payment">
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 form-group">
                    <ul class="user-profile-list two">
                        <li class="one"><?php echo e(__("Charge")); ?>: <span><?php echo e(number_format(@$data->charge->total_charge,2)); ?> <?php echo e(@$data->currency->currency_code); ?></span></li>
                        <li class="two"><?php echo e(__("After Charge")); ?>: <span><?php echo e(number_format(@$data->payable,2)); ?> <?php echo e(@$data->currency->currency_code); ?></span></li>
                        <li class="three"><?php echo e(__("Rate")); ?>: <span>1 <?php echo e(get_default_currency_code()); ?> = <?php echo e(number_format(@$data->currency->rate,2)); ?> <?php echo e(@$data->currency->currency_code); ?></span></li>
                        <li class="four"><?php echo e(__("Payable")); ?>: <span><?php echo e(number_format(@$data->payable,2)); ?> <?php echo e(@$data->currency->currency_code); ?></span></li>
                        <li class="five"><?php echo e(__("Status")); ?>:  <span class="<?php echo e(@$data->stringStatus->class); ?>"><?php echo e(@$data->stringStatus->value); ?></span></li>
                    </ul>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if(@$data->status == 2): ?>
<div class="custom-card mt-15">
    <div class="card-header">
        <h6 class="title"><?php echo e(__("Information of Logs")); ?></h6>
    </div>
    <div class="card-body">
        <ul class="product-sales-info">

            <?php $__currentLoopData = $data->details ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
                <?php if($item->type == "file"): ?>
                    <?php
                        $file_link = get_file_link("kyc-files",$item->value);
                    ?>
                    <span class="kyc-title"><?php echo e(__($item->label)); ?>:</span>
                    <?php if(its_image($item->value)): ?>
                        <div class="kyc-image ">
                            <img class="img-fluid" width="200px" src="<?php echo e($file_link); ?>" alt="<?php echo e(__($item->label)); ?>">
                        </div>
                    <?php else: ?>
                        <span class="text--danger">
                            <?php
                                $file_info = get_file_basename_ext_from_link($file_link);
                            ?>
                            <a href="<?php echo e(setRoute('file.download',["kyc-files",$item->value])); ?>" >
                                <?php echo e(Str::substr($file_info->base_name ?? "", 0 , 20 ) ."..." . $file_info->extension ?? ""); ?>

                            </a>
                        </span>
                    <?php endif; ?>
                <?php else: ?>
                    <span class="kyc-title"><?php echo e(__($item->label)); ?>:</span>
                    <span><?php echo e($item->value); ?></span>
                <?php endif; ?>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="product-sales-btn">
            <button type="button" class="btn btn--base approvedBtn"><?php echo e(__("Approve")); ?></button>
            <button type="button" class="btn btn--danger rejectBtn" ><?php echo e(__("Reject")); ?></button>
        </div>
    </div>
</div>

<div class="modal fade" id="approvedModal" tabindex="-1" >
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header p-3" id="approvedModalLabel">
                <h5 class="modal-title"><?php echo e(__("Approved Confirmation")); ?> ( <span class="fw-bold text-danger"><?php echo e(number_format(@$data->request_amount,2)); ?> <?php echo e(get_default_currency_code()); ?></span> )</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="modal-form" action="<?php echo e(setRoute('admin.add.money.approved')); ?>" method="POST">

                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <input type="hidden" name="id" value=<?php echo e(@$data->id); ?>>
                           <p><?php echo e(__("Are you sure to approved this request?")); ?></p>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--danger" data-bs-dismiss="modal"><?php echo e(__("Cancel")); ?></button>
                <button type="submit" class="btn btn--base btn-loading"><?php echo e(__("Approved")); ?></button>
            </div>
        </form>
        </div>
    </div>
</div>
<div class="modal fade" id="rejectModal" tabindex="-1" >
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header p-3" id="rejectModalLabel">
                <h5 class="modal-title"><?php echo e(__("Rejection Confirmation")); ?> ( <span class="fw-bold text-danger"><?php echo e(number_format(@$data->request_amount,2)); ?> <?php echo e(get_default_currency_code()); ?></span> )</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form class="modal-form" action="<?php echo e(setRoute('admin.add.money.rejected')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field("PUT"); ?>
                    <div class="row mb-10-none">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <input type="hidden" name="id" value=<?php echo e(@$data->id); ?>>
                            <?php echo $__env->make('admin.components.form.textarea',[
                                'label'         => __('Explain Rejection Reason*'),
                                'name'          => 'reject_reason',
                                'value'         => old('reject_reason')
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn--danger" data-bs-dismiss="modal"><?php echo e(__("Cancel")); ?></button>
                <button type="submit" class="btn btn--base"><?php echo e(__("Confirm")); ?></button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php endif; ?>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function(){
        <?php if($errors->any()): ?>
        var modal = $('#rejectModal');
        modal.modal('show');
        <?php endif; ?>
    });
</script>
<script>
     (function ($) {
        "use strict";
        $('.approvedBtn').on('click', function () {
            var modal = $('#approvedModal');
            modal.modal('show');
        });
        $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.modal('show');
        });
    })(jQuery);





</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp-8.0.2\htdocs\strip_card\v3.8.0\full_project\resources\views/admin/sections/add-money/details.blade.php ENDPATH**/ ?>